#!/usr/bin/perl

####################################################################
#
#   chswlogtop command
#
#   Syntax:  chswlogtop { -p <num_planes> -t <topology> [-n <num_networks>] | -q | -h }
#
#    -n <num_networks> - Specifies the number of planes for the cluster.  
#                         Valid values are 1 or 2. 
#    -p <num_planes>   - Specifies the number of planes for the cluster.  
#                         Valid values are 1 or 2. 
#    -t <topology>     - Specifies the toplogy for the cluster.  
#			  Valid values are:
#		 	   1NSB_0ISB
#		 	   2NSB_0ISB
#			   3NSB_0ISB
#			   4NSB_2ISB
#			   8NSB_4ISB
#                          16NSB_8ISB
#                          32NSB_16ISB
#    -q 	       - Writes the current logical topology, which is one of
#			  the values above, to standard output.  If no 
#			  logical topology is set, "None" is written to 
#			  standard output.
#    -h                - Displays the syntax of the command 
#
####################################################################
#
#   Initial version - 3/15/04
#   "@(#)20   1.4   src/hmcpok/commands/chswlogtop.perl, fnm.websm, hmcpok_rel3, rel3s013a 8/5/04 11:30:45"
####################################################################

$ret = 0;			#default return value set

#check for the existance of the fnmSwConfig file
$Config_File = "/opt/hsc/data/fnmSwConfig";
if(stat("$Config_File"))
{
        #print "fnmSwConfig exists!, setting flag=1\n";
	$fnmSwConfig = 1;
}
else
{
	#print "fnmSwConfig does not exist!, setting flag=0\n";
	$fnmSwConfig = 0;
}
#easy way to get command line options
use Getopt::Long;

#routine to exit the script
sub exit_routine {
     exit $ret;

} # end exit_routine subroutine

@Network_Types[0] = "1NSB_0ISB_16EP";
@Network_Types[1] = "2NSB_0ISB_32EP";
@Network_Types[2] = "3NSB_0ISB_48EP";
@Network_Types[3] = "4NSB_2ISB_64EP";
@Network_Types[4] = "8NSB_4ISB_128EP";
@Network_Types[5] = "16NSB_8ISB_256EP";
@Network_Types[6] = "32NSB_16ISB_512EP";

################################################################################
#
# start main body of code
#
################################################################################
$PRGRM  = "chswlogtop";                 #program name
$BIN = "/opt/hsc/bin";			#program location
$chswnm = "/opt/hsc/bin/chswnm -q";	#location of dependant script

$USAGE = "\nUsage: chswlogtop { [-n <num_networks>] -p <num_planes> -t <topology> | -q | -h }\n\n"; #usage statement
$USAGE .= "Example: 1 Network System - 2 Planes each with 8 NSB's 4 ISB's & 128 Endpoints\n";
$USAGE .= "chswlogtop -n 1 -p 2 -t 8NSB_4ISB_128EP\n\n";
$USAGE .= "Valid Topologies are:\n";
$USAGE .= "\t1NSB_0ISB_16EP\n";
$USAGE .= "\t2NSB_0ISB_32EP\n";
$USAGE .= "\t3NSB_0ISB_48EP\n";
$USAGE .= "\t4NSB_2ISB_64EP\n";
$USAGE .= "\t8NSB_4ISB_128EP\n";
$USAGE .= "\t16NSB_8ISB_256EP\n";
$USAGE .= "\t32NSB_16ISB_512EP\n"; 
# First check for existence of parameters
if ($#ARGV == -1) {
        #print "No parms given\n";     #DEBUG
        print $USAGE;		#if no parameters print USAGE and exit with rc=2
        $ret = 2;
        &exit_routine;
}

Getopt::Long::Configure("no_ignore_case");   #ignore case for command line options
$result = GetOptions(			#get various options off the command line
        "h" => \$help,
	"n=s" => \$networks,
        "p=s" => \$num_planes,
        "t=s" => \$topology,
        "q" => \$curr_top,
	"help" => \$help
);
if ($result == 0)
{
	$help = 1;
}
#----------------------------------------------------------------------------------#
if ($help) {				#if -h print USAGE and exit with rc=0
        print $USAGE;      #USAGE
        $ret = 0;
        &exit_routine;
}
#----------------------------------------------------------------------------------#
# Now that we've determined that the user specified all the required parms
#      and passed reasonable values with them, issue the chswnm command to check
#      if the daemon running
$chswnm_return = `$chswnm`;

# Check return code from chswnm 
if ( ($chswnm_return != 1) && ($chswnm_return !=2) ) {
        # Non-zero return code from i_stub_FS
	if ($curr_top != 1)
	{
		$ret = 1;
        	&exit_routine;
	}
}
#----------------------------------------------------------------------------------#
if (defined $networks) {		#if value after -n store
        $networks_parm = $networks;
        if ($networks_parm =~ /\D/) {		#if not number print USAGE exit rc=2
                print "Bad -n value - not a number...defaulting to one\n"; #DEBUG
        }
	elsif ($networks_parm > 1) {    #invalid if networks_parm > 1 (not supported)
		print "-n value greater than 1 networks...defaulting to one\n";     #DEBUG
	}
}
$networks_parm = 1;                          #default networks to one for no
#----------------------------------------------------------------------------------#
if (defined $num_planes) {
        $planes_parm = $num_planes;
        if ($planes_parm =~ /\D/) {
                print $USAGE;
                $ret = 2;
                &exit_routine;
        }
	elsif ( ($planes_parm == 0) or ($planes_parm > 2) ) { 	#more than 2 planes (1,2) not supported
		print $USAGE;
		$ret = 2;
		&exit_routine;
	}
}
elsif ($curr_top != 1) {					# No -p or nothing else was specified after -p
        print $USAGE;			#print USAGE exit with rc=2
        $ret = 2;
        &exit_routine;
}
#----------------------------------------------------------------------------------#
$match =0;
if (defined $topology) {
        $topology_parm = $topology;
	foreach $item (@Network_Types) {		#search through topology types for a match
		if ($item eq $topology_parm)
		{
			$match = 1;
		}
	}
	if ($match == 0)
	{
		print $USAGE;
                $ret = 2;
                &exit_routine;
	}
}
elsif ($curr_top != 1) {                                        # No -p or nothing else was specified after -p
        print $USAGE;                   #print USAGE exit with rc=2
        $ret = 2;
        &exit_routine;
}
if ($curr_top != 1)		#TIME TO WRITE TOPOLOGY FILE 
{
	open(FILE, "> $Config_File") or die "Can't open fnmSwConfig: $!\n";	#open file for writing
	flock(FILE, 2) or die "Can't get a lock on fnmSwConfig: $!\n";

	print FILE $networks_parm or die "can't write $Config_File: $!";     #print to file the new topology
	print FILE " " or die "can't write $Config_File: $!";
	print FILE $planes_parm or die "can't write $Config_File: $!";
	print FILE " " or die "can't write $Config_File: $!";

	@split_array  = unpack("A1" x length($topology_parm), $topology_parm);   #unpack topology parameter
	$topology_parm_new = @split_array[0];					#set first char in 2 char string
	if ( (@split_array[1] == 6) or (@split_array[1] == 2) )		#if second char is 6 or 2 then either 16 or 32 NSBS
	{
		$topology_parm_new .= @split_array[1];			#set second char
	}
	print FILE $topology_parm_new or die "can't write $Config_File: $!";	#write topology to file
	$ret = 0;
	close(FILE)


}
#----------------------------------------------------------------------------------#
if ($curr_top) {                            #if -q option specified
	if ($fnmSwConfig == 1)
	{
		#-----------------------READ FILE---------------------------------------#
		open(FILE, "< $Config_File") or die "Can't open fnmSwConfig: $!\n";
		while(<FILE>) {				#open file, read, store in variable
			chomp $_;
			$line_in .= $_; 
		}
		close(FILE);				#close, we are done 
		
		@store = unpack("A1" x length($line_in), $line_in);   #unpack file by char into array
		$network_store = @store[0];			      #Pos one is the network def: 1
		$plane_store = @store[2];			      #Pos three is the plane 
			#------CHECK IF VALID INFORMATION, ELSE EXIT-----#
			if ( ($network_store == 1) and ( ($plane_store > 0) and ($plane_store < 3) ) )
			{
				$file_valid = 1;
			}
			else
			{
				$ret = 0;
                		&exit_routine;
			}
		$temp = @store[5];			#store 6th value to check if 16 or 32 NSB's
		if ( ($temp !=~ /\D/)  )	#check if that value is indeed a number
		{
			$two_digit=1;			#if so we know its valid and we can assume 16 or 32 NSB
		}
		$top_store = @store[4];		#store first value
		if ($two_digit=1)
		{
			$top_store .= $temp;	#if two digits, store 2nd value
	        }
		#-----------------------READ FILE---------------------------------------#

		#-----------------------CHECK VALID TOPOLOGY---------------------------------------#
		if ( ($top_store == 1) or ($top_store ==2) or ($top_store==3) or ($top_store==4) or ($top_store==8) )
		{
			$file_valid = 1;
		}
		elsif ( ($top_store == 16) or ($top_store ==32) )
		{
			$file_valid = 1;
		}
		else 
		{
			$file_valid = 0;
			$ret = 0;
                	&exit_routine;
		} 
		#-----------------------CHECK VALID TOPOLOGY---------------------------------------#
		#final check to see if all variables are indeed numbers
		if ( ($network_store =~ /\D/) or ($plane_store =~ /\D/) or ($top_store =~ /\D/) )
		{
			$file_valid = 0;
			$ret = 0;
                	&exit_routine;
		}
		else
		{
			$file_valid = 1; 
					#if file valid and matches one of the following types then OK
			if ($top_store == 1)
			{
				$top_store = "1NSB_0ISB_16EP";
			}
			elsif ($top_store == 2) 
			{
                                $top_store = "2NSB_0ISB_32EP";
                        }
                        elsif ($top_store == 3)
                        {
                                $top_store = "3NSB_0ISB_48EP";
                        }
                        elsif ($top_store == 4)
                        {
                               $top_store = "4NSB_2ISB_64EP";
                        }
                        elsif ($top_store == 8)
                        {
                                $top_store = "8NSB_4ISB_128EP";
                        }
                        elsif ($top_store == 16)
                        {
                                $top_store = "16NSB_8ISB_256EP";
                        }
                        elsif ($top_store == 32)
                        {
                                $top_store = "32NSB_16ISB_512EP";
			}
			else
			{
				print "Warning: fnmSwConfig did not have valid topology\n";
				$top_store = "INVALID_TOPOLOGY";
			}
			print "$network_store $plane_store $top_store\n";
		}  
	}

	if ( ($fnmSwConfig == 0) ) 
	{			
		print "None\n";			#if file does not exit, print NONE to standard output and exit
		$ret = 0;
        	&exit_routine;
	}
}

&exit_routine;
 
